//Source file: H:\middleware\src\Alkindi\BusinessDataTypes\UserRatingsList.java

package Alkindi.Services.InternalData;

import Alkindi.Data.Rating;
import java.util.Iterator;
import java.util.HashMap;
import Alkindi.Data.ProductList;
import Alkindi.Data.SystemUser;

/* 
$Header: UserRatingsList.java, 18, 4/26/01 2:37:00 PM, Schwartz, Joe$
$Log: 
 18   Alkindi Development1.17        4/26/01 2:37:00 PM   Schwartz, Joe  
      Modifed to account for movement to new packages.
 17   Alkindi Development1.16        4/26/01 1:46:08 PM   Schwartz, Joe   Moved
      to new package.
 16   Alkindi Development1.15        2/14/01 6:20:41 PM   Schwartz, Joe  
      Improved some local variable names.
 15   Alkindi Development1.14        2/13/01 5:54:46 PM   Schwartz, Joe  
      Changed to account for new SparseRatingsArray class, used for base class
      of RatingSpacePoint.
 14   Alkindi Development1.13        1/26/01 5:48:31 PM   Schwartz, Joe  
      Improving efficiency.
 13   Alkindi Development1.12        1/23/01 1:45:48 PM   Schwartz, Joe  
      Modified to work with floats instead of doubles.
 12   Alkindi Development1.11        1/22/01 1:46:42 PM   Schwartz, Joe  
      Modified to account for new RatingSpacePoint base class of VMeans &
      UserCluster.
 11   Alkindi Development1.10        12/28/00 1:07:29 PM  Schwartz, Joe   Added
      Version Control header info.
 10   Alkindi Development1.9         12/26/00 6:57:17 PM  Schwartz, Joe   
 9    Alkindi Development1.8         12/18/00 12:06:26 PM Schwartz, Joe   Moved
      from (public) BusinessDataTypes package.
 8    Alkindi Development1.7         12/15/00 6:18:00 PM  Schwartz, Joe  
      Changed internal storage from Vector to hash of SystemUsers/UserRatings
      objects.
 7    Alkindi Development1.6         12/3/00 5:28:01 PM   Schwartz, Joe   
 6    Alkindi Development1.5         12/2/00 1:01:55 PM   Schwartz, Joe   
 5    Alkindi Development1.4         12/1/00 9:48:29 PM   Schwartz, Joe   
 4    Alkindi Development1.3         10/22/00 2:58:57 PM  Schwartz, Joe  
      Changed package to BeanImpl.
 3    Alkindi Development1.2         10/22/00 10:38:48 AM Schwartz, Joe  
      AppianDelivery 10.20.00
 2    Alkindi Development1.1         10/17/00 2:16:36 PM  Schwartz, Joe  
      Delivery 10.16.00
 1    Alkindi Development1.0         10/7/00 4:26:03 PM   Schwartz, Joe   
$
$NoKeywords$
 */

/**
 * A List of User Ratings, which means that this is really a list of RaitingLists. It also contains a single list of the products that are evaluated from the PC. Internally, this list is implemented as a hash with SystemUser objects as keys and UserRatings objects as values.
 */
public class UserRatingsList 
{
	
	/**
	 * This internal hash mapping SystemUsers to UserRatings.
	 */
	private HashMap internalMap;
	
	/**
	 * A list of the products rated in the evaluations. Each product appears only once.
	 */
	public ProductList products;
	
	public UserRatingsList() 
	{
		internalMap = new HashMap();
		products = new ProductList();
	}
	
	/**
	 * @roseuid 3A284DAF003E
	 */
	public UserRatingsList(final int size) 
	{
		internalMap = new HashMap(size);
		products = new ProductList();
	}
	
	/**
	 * Adds a given SystemUser / UserRatings pair to the internal hash.
	 * @roseuid 3A284DC500BB
	 */
	public void add(UserRatings itemToAdd) 
	{
		internalMap.put((itemToAdd.user()), itemToAdd);
	}
	
	/**
	 * Retrieves the UserRatings item for the given SystemUser. If it does not exists, null is returned. Note that the internal map can also map a key to a null value.
	 * @roseuid 3A284DC90222
	 */
	public UserRatings get(SystemUser user) 
	{
		return (UserRatings)internalMap.get(user);
	}
	
	/**
	 * Adds the given Rating object to the UserRatings item corresponding to the Rating's SystemUser. If the UserRatings item for the given Rating's user does not exist, this method creates a new one and adds it to the main list.
	 * @roseuid 3A28545702CE
	 */
	public void addRating(Rating rating) 
	{
		UserRatings ur = get(rating.user);
		if (null == ur) {
			ur = new UserRatings(rating.user);
			add(ur);
		}
		ur.putEval(rating.prod.id, (float)rating.evaluation);
		return;
	}
	
	/**
	 * @roseuid 3A291FB5002E
	 */
	public int numUsers() 
	{
		return internalMap.size();
	}
	
	/**
	 * @roseuid 3A291FBB008C
	 */
	public int numProducts() 
	{
		return products.size();
	}
	
	/**
	 * Returns an iterator of the hash keys.
	 * @roseuid 3A3A5DE500AB
	 */
	public java.util.Iterator userIterator() 
	{
		return internalMap.keySet().iterator();
	}
	
	/**
	 * Returns a regular array of the Map.Entry objects that are mapped in the hash.
	 * @roseuid 3A3A602B005D
	 */
	public Object[] mapEntryArray() 
	{
		return internalMap.entrySet().toArray();
	}
	
	/**
	 * Returns an Iterator for the UserRatings objects stored in the interal hash.
	 * @roseuid 3A3A80FC03C8
	 */
	public java.util.Iterator userRatingsIterator() 
	{
		return internalMap.values().iterator();
	}
}
